/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXDocumentIndexes
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XIndexAccess oObj = null;
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        log.println("creating a test environment");
        XTextContent xTC = null;
        try {
            xTC = SOfficeFactory.createIndex(this.xTextDoc, "com.sun.star.text.ContentIndex");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create the Index", e);
        }
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting the Index into text document");
        try {
            oText.insertTextContent(oCursor, xTC, false);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert the Index", e);
        }
        XDocumentIndexesSupplier xDocInd = UnoRuntime.queryInterface(XDocumentIndexesSupplier.class, (Object)this.xTextDoc);
        oObj = xDocInd.getDocumentIndexes();
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

