/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XDocumentIndexMark;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXDocumentIndexMark
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        Object oDIM = null;
        Object instance = null;
        try {
            oDIM = oDocMSF.createInstance("com.sun.star.text.DocumentIndexMark");
            instance = oDocMSF.createInstance("com.sun.star.text.DocumentIndexMark");
        }
        catch (Exception e) {
            log.println("Error:" + e);
        }
        XDocumentIndexMark xDIM = UnoRuntime.queryInterface(XDocumentIndexMark.class, oDIM);
        try {
            xDIM.attach(oText);
        }
        catch (IllegalArgumentException e) {
            log.println("Error: " + e);
            e.printStackTrace(log);
            throw new StatusException("Couldn't attach IndexMark", e);
        }
        try {
            oText.insertTextContent(oCursor, xDIM, false);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert the DocumentIndexMark", e);
        }
        TestEnvironment tEnv = new TestEnvironment(xDIM);
        tEnv.addObjRelation("CONTENT", UnoRuntime.queryInterface(XTextContent.class, instance));
        tEnv.addObjRelation("RANGE", this.xTextDoc.getText().createTextCursor());
        return tEnv;
    }
}

