/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXDocumentIndex
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XTextContent xTC = null;
        XTextContent instance = null;
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        log.println("creating a test environment");
        try {
            xTC = SOfficeFactory.createIndex(this.xTextDoc, "com.sun.star.text.DocumentIndex");
            instance = SOfficeFactory.createIndex(this.xTextDoc, "com.sun.star.text.DocumentIndex");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create the Index", e);
        }
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting the Index into text document");
        try {
            oText.insertTextContent(oCursor, xTC, false);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert the Index", e);
        }
        TestEnvironment tEnv = new TestEnvironment(xTC);
        tEnv.addObjRelation("CONTENT", UnoRuntime.queryInterface(XTextContent.class, (Object)instance));
        tEnv.addObjRelation("TextDoc", this.xTextDoc);
        return tEnv;
    }
}

