/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class SwXCellRange
extends TestCase {
    SOfficeFactory SOF;
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XTextTable the_table = null;
        XCellRange oObj = null;
        try {
            the_table = SOfficeFactory.createTextTable(this.xTextDoc);
            the_table.initialize(5, 5);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create testobj: " + e.getMessage(), e);
        }
        if (SOfficeFactory.getTableCollection(this.xTextDoc).getCount() == 0) {
            try {
                SOfficeFactory.insertTextContent(this.xTextDoc, the_table);
            }
            catch (Exception e) {
                e.printStackTrace(log);
                throw new StatusException("Couldn't create TextTable : " + e.getMessage(), e);
            }
        }
        try {
            XCellRange the_Range = UnoRuntime.queryInterface(XCellRange.class, (Object)the_table);
            oObj = the_Range.getCellRangeByPosition(0, 0, 3, 4);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get CellRange : " + e.getMessage(), e);
        }
        log.println("Creating instance...");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("ImplName: " + utils.getImplName(oObj));
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        try {
            XInterface oTS = (XInterface)oDocMSF.createInstance("com.sun.star.text.TextSection");
            log.println("  adding TextSection object");
            tEnv.addObjRelation("CellProperties.TextSection", oTS);
        }
        catch (Exception e) {
            log.println("Could not get instance of TextSection");
            e.printStackTrace(log);
        }
        Object[][] NewData = new Object[][]{{new Double(2.5), new Double(5.0), new Double(2.5), new Double(5.0)}, {new Double(4.0), new Double(9.0), new Double(2.5), new Double(5.0)}, {new Double(2.5), new Double(5.0), new Double(2.5), new Double(5.0)}, {new Double(2.5), new Double(5.0), new Double(2.5), new Double(5.0)}, {new Double(4.0), new Double(9.0), new Double(2.5), new Double(5.0)}};
        tEnv.addObjRelation("NewData", NewData);
        tEnv.addObjRelation("CRDESC", "Column and RowDescriptions can't be changed for this Object");
        return tEnv;
    }
}

