/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCell;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXCell
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XCell oObj = null;
        XTextTable oTable = null;
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        log.println("creating a test environment");
        try {
            oTable = SOfficeFactory.createTextTable(this.xTextDoc, 3, 4);
        }
        catch (Exception e) {
            log.println("Unable to create TextTable...");
            e.printStackTrace(log);
        }
        try {
            SOfficeFactory.insertTextContent(this.xTextDoc, oTable);
        }
        catch (IllegalArgumentException e) {
            log.println("Unable to insert TextContent...");
            e.printStackTrace(log);
        }
        oObj = SOfficeFactory.getFirstTableCell(oTable);
        log.println("    creating a new environment for bodytext object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        try {
            XInterface oTS = (XInterface)oDocMSF.createInstance("com.sun.star.text.TextSection");
            log.println("  adding TextSection object");
            tEnv.addObjRelation("CellProperties.TextSection", oTS);
        }
        catch (Exception e) {
            log.println("Could not get instance of TextSection");
            e.printStackTrace(log);
        }
        return tEnv;
    }
}

