/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XBookmarksSupplier;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXBookmarks
extends TestCase {
    XTextDocument xTextDoc;
    SOfficeFactory SOF;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        log.println("creating a test environment");
        try {
            oObj = SOfficeFactory.createBookmark(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, oObj);
            oObj = SOfficeFactory.createBookmark(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, oObj);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create Bookmark", e);
        }
        XBookmarksSupplier oBSupp = UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.xTextDoc);
        XNameAccess oBookNA = oBSupp.getBookmarks();
        oObj = oBookNA;
        log.println("creating a new environment for Bookmarks object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

