/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.dbg;

public class SwXBookmark
extends TestCase {
    XTextDocument xTextDoc;
    SOfficeFactory SOF;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        XTextContent oObj = null;
        Object instance = null;
        log.println("creating a test environment");
        try {
            oObj = SOfficeFactory.createBookmark(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, oObj);
            instance = SOF.createInstance(this.xTextDoc, "com.sun.star.text.Bookmark");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create Bookmark", e);
        }
        log.println("creating a new environment for bodytext object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        dbg.printInterfaces((XInterface)instance);
        tEnv.addObjRelation("CONTENT", UnoRuntime.queryInterface(XTextContent.class, instance));
        tEnv.addObjRelation("RANGE", this.xTextDoc.getText().createTextCursor());
        return tEnv;
    }
}

