/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.ParagraphDsc;
import util.SOfficeFactory;
import util.TableDsc;

public class SwXBodyText
extends TestCase {
    XTextDocument xTextDoc = null;
    SOfficeFactory SOF = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XText oObj = null;
        log.println("creating a test environment");
        log.println("    getting the bodytext of textdocument with getText()");
        oObj = this.xTextDoc.getText();
        log.println("    creating a new environment for bodytext object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println(" adding Text as ObjRelation");
        tEnv.addObjRelation("TEXT", oObj);
        log.println("    adding InstDescriptor object");
        TableDsc tDsc = new TableDsc(6, 4);
        log.println("    adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(this.xTextDoc, tDsc));
        log.println("    adding Paragraph");
        ParagraphDsc pDsc = new ParagraphDsc();
        tEnv.addObjRelation("PARA", new InstCreator(this.xTextDoc, pDsc));
        return tEnv;
    }
}

