/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XAutoTextContainer;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class SwXAutoTextGroup
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAutoTextContainer oContainer;
        XInterface oObj = null;
        log.println("creating a test environment");
        try {
            XMultiServiceFactory myMSF = (XMultiServiceFactory)Param.getMSF();
            Object oInst = myMSF.createInstance("com.sun.star.text.AutoTextContainer");
            oContainer = UnoRuntime.queryInterface(XAutoTextContainer.class, oInst);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create AutoTextContainer", e);
        }
        String myGroupName = "myNewGroup2*1";
        XAutoTextContainer xATC = UnoRuntime.queryInterface(XAutoTextContainer.class, (Object)oContainer);
        try {
            log.println("removing element with name '" + myGroupName + "'");
            xATC.removeByName(myGroupName);
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            log.println("adding element with name '" + myGroupName + "'");
            xATC.insertNewByName(myGroupName);
        }
        catch (ElementExistException ex) {
            ex.printStackTrace(log);
            throw new StatusException("could not insert '" + myGroupName + "' into container", ex);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace(log);
            throw new StatusException("could not insert '" + myGroupName + "' into container", ex);
        }
        XNameAccess oContNames = UnoRuntime.queryInterface(XNameAccess.class, (Object)oContainer);
        if (Param.getBool("DebugIsActive")) {
            String[] contNames = oContNames.getElementNames();
            for (int i = 0; i < contNames.length; ++i) {
                log.println("ContainerNames[ " + i + "]: " + contNames[i]);
            }
        }
        try {
            oObj = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)oContNames.getByName(myGroupName));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get AutoTextGroup '" + myGroupName + "'", e);
        }
        log.println("ImplementationName " + utils.getImplName(oObj));
        log.println("creating a new environment for AutoTextGroup object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XText oText = this.xTextDoc.getText();
        oText.insertString(oText.getStart(), "New AutoText", true);
        log.println("adding TextRange as mod relation to environment");
        tEnv.addObjRelation("TextRange", oText);
        return tEnv;
    }
}

