/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XAutoTextContainer;
import com.sun.star.text.XAutoTextEntry;
import com.sun.star.text.XAutoTextGroup;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DefaultDsc;
import util.DesktopTools;
import util.InstCreator;
import util.SOfficeFactory;

public class SwXAutoTextEntry
extends TestCase {
    XTextDocument xTextDoc;
    XAutoTextGroup oGroup;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        XMultiServiceFactory msf = (XMultiServiceFactory)tParam.getMSF();
        SOfficeFactory SOF = SOfficeFactory.getFactory(msf);
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        try {
            if (this.oGroup.hasByName("NewEntryName")) {
                log.println("Removing 'NewEntryName' element");
                this.oGroup.removeByName("NewEntryName");
            }
        }
        catch (NoSuchElementException e) {
            log.println("Cannot remove TextEntry from group...");
            e.printStackTrace(log);
        }
        log.println("disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAutoTextContainer oContainer;
        XAutoTextEntry oEntry = null;
        XInterface oObj = null;
        boolean n = false;
        boolean nCount = false;
        log.println("creating a test environment");
        try {
            XMultiServiceFactory myMSF = (XMultiServiceFactory)Param.getMSF();
            Object oInst = myMSF.createInstance("com.sun.star.text.AutoTextContainer");
            oContainer = UnoRuntime.queryInterface(XAutoTextContainer.class, oInst);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create AutoTextContainer", e);
        }
        XNameAccess oContNames = UnoRuntime.queryInterface(XNameAccess.class, (Object)oContainer);
        String[] contNames = oContNames.getElementNames();
        for (int i = 0; i < contNames.length; ++i) {
            log.println("ContainerNames[ " + i + "]: " + contNames[i]);
        }
        try {
            oObj = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)oContNames.getByName("mytexts"));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get AutoTextGroup", e);
        }
        this.oGroup = UnoRuntime.queryInterface(XAutoTextGroup.class, (Object)oObj);
        String[] oENames = this.oGroup.getElementNames();
        for (int i = 0; i < oENames.length; ++i) {
            log.println("AutoTextEntryNames[" + i + "]: " + oENames[i]);
        }
        XText oText = this.xTextDoc.getText();
        oText.insertString(oText.getStart(), "New AutoText", true);
        XTextRange oTextRange = oText;
        try {
            if (this.oGroup.hasByName("NewEntryName")) {
                this.oGroup.removeByName("NewEntryName");
                log.println("Element 'NewEntryName' exists, removing...");
            }
            log.println("Adding new element 'NewEntryName' to group...");
            this.oGroup.insertNewByName("NewEntryName", "NewEntryTitle", oTextRange);
            oEntry = (XAutoTextEntry)AnyConverter.toObject((Type)new Type(XAutoTextEntry.class), (Object)this.oGroup.getByName("NewEntryName"));
        }
        catch (ElementExistException e) {
            e.printStackTrace(log);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
        }
        oObj = oEntry;
        log.println("Trying to use XText as TextRange in the method applyTo");
        oEntry.applyTo(oTextRange);
        oTextRange = oText.createTextCursor();
        log.println("Trying to use XTextCursor as TextRange in the method applyTo");
        oEntry.applyTo(oTextRange);
        log.println("creating a new environment for AutoTextEntry object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        DefaultDsc tDsc = new DefaultDsc("com.sun.star.text.XTextContent", "com.sun.star.text.TextField.DateTime");
        log.println("    adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(this.xTextDoc, tDsc));
        log.println("adding TextDocument as mod relation to environment");
        tEnv.addObjRelation("TEXTDOC", this.xTextDoc);
        return tEnv;
    }
}

