/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XViewSettingsSupplier;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.WriterTools;
import util.utils;

public class SwAccessibleTableView
extends TestCase {
    XTextDocument xTextDoc = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        XTextTable oTable = null;
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            oTable = SOfficeFactory.createTextTable(this.xTextDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create TextTable : " + e.getMessage(), e);
        }
        try {
            SOfficeFactory.insertTextContent(this.xTextDoc, oTable);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert text content :" + e.getMessage(), e);
        }
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)58);
        oObj = AccessibilityTools.SearchedContext;
        log.println("ImplementationName " + utils.getImplName(oObj));
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XController xController = this.xTextDoc.getCurrentController();
        XViewSettingsSupplier xViewSetSup = UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)xController);
        final XPropertySet PropSet = xViewSetSup.getViewSettings();
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    PropSet.setPropertyValue("ZoomValue", new Short("15"));
                    PropSet.setPropertyValue("ZoomValue", new Short("100"));
                }
                catch (WrappedTargetException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (PropertyVetoException e) {
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    // empty catch block
                }
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("dispose text document");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        log.println("creating a text document");
        this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)Param.getMSF());
    }
}

