/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.BreakType;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.WriterTools;
import util.utils;

public class SwAccessiblePageView
extends TestCase {
    XTextDocument xTextDoc = null;
    public static boolean first = false;
    public static XAccessibleContext SearchedContext = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        XInterface port = null;
        XInterface para = null;
        XPropertySet paraP = null;
        XPropertySet portP = null;
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting some lines");
        try {
            for (int i = 0; i < 2; ++i) {
                oText.insertString(oCursor, "Paragraph Number: " + i, false);
                oText.insertString(oCursor, " The quick brown fox jumps over the lazy Dog: SwXParagraph", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                oText.insertString(oCursor, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG: SwXParagraph", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                oText.insertControlCharacter(oCursor, (short)1, false);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert lines", e);
        }
        XEnumerationAccess oEnumA = UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)oText);
        XEnumeration oEnum = oEnumA.createEnumeration();
        try {
            para = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)oEnum.nextElement());
            XEnumerationAccess oEnumB = UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)para);
            XEnumeration oEnum2 = oEnumB.createEnumeration();
            port = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)oEnum2.nextElement());
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            log.println("Error: exception occured...");
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
            log.println("Error: exception occured...");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            log.println("Error: exception occured...");
        }
        try {
            portP = UnoRuntime.queryInterface(XPropertySet.class, port);
            paraP = UnoRuntime.queryInterface(XPropertySet.class, (Object)para);
            paraP.setPropertyValue("BreakType", BreakType.PAGE_AFTER);
        }
        catch (WrappedTargetException e) {
            log.println("Error, exception occured...");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Paragraph", e);
        }
        catch (IllegalArgumentException e) {
            log.println("Error, exception occured...");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Paragraph", e);
        }
        catch (UnknownPropertyException e) {
            log.println("Error, exception occured...");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Paragraph", e);
        }
        catch (PropertyVetoException e) {
            log.println("Error, exception occured...");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Paragraph", e);
        }
        this.shortWait();
        XController xController = this.xTextDoc.getCurrentController();
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        try {
            XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
            XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.util.URLTransformer"));
            URL[] aParseURL = new URL[]{new URL()};
            aParseURL[0].Complete = ".uno:PrintPreview";
            xParser.parseStrict(aParseURL);
            URL aURL = aParseURL[0];
            XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
            if (xDispatcher != null) {
                xDispatcher.dispatch(aURL, null);
            }
        }
        catch (Exception e) {
            log.println("Couldn't change mode");
            throw new StatusException(Status.failed("Couldn't change mode"));
        }
        this.shortWait();
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        System.out.println("Panel: 40");
        System.out.println("ScrollPane: 51");
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)40, "Page");
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        SwAccessiblePageView.getAccessibleObjectForRole(xRoot, (short)50);
        final XAccessibleValue xAccVal = UnoRuntime.queryInterface(XAccessibleValue.class, (Object)SearchedContext);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                Integer old = (Integer)xAccVal.getCurrentValue();
                Integer newValue = new Integer(old + 10);
                xAccVal.setCurrentValue(newValue);
                xAccVal.setCurrentValue(old);
            }
        });
        return tEnv;
    }

    public static void getAccessibleObjectForRole(XAccessible xacc, short role) {
        XAccessibleContext ac = xacc.getAccessibleContext();
        if (ac.getAccessibleRole() == role) {
            if (first) {
                SearchedContext = ac;
            } else {
                first = true;
            }
        } else {
            int k = ac.getAccessibleChildCount();
            for (int i = 0; i < k; ++i) {
                try {
                    SwAccessiblePageView.getAccessibleObjectForRole(ac.getAccessibleChild(i), role);
                    if (SearchedContext == null) continue;
                    return;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("Couldn't get Child");
                }
            }
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("dispose text document");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        log.println("creating a text document");
        this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)Param.getMSF());
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

