/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XFootnote;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XViewSettingsSupplier;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.WriterTools;
import util.utils;

public class SwAccessibleFootnoteView
extends TestCase {
    XTextDocument xTextDoc = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        XFootnote oFootnote = null;
        log.println("Creating a test environment");
        XMultiServiceFactory msf = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        log.println("creating a footnote");
        try {
            oFootnote = UnoRuntime.queryInterface(XFootnote.class, msf.createInstance("com.sun.star.text.Footnote"));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create footnote", e);
        }
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting the footnote into text document");
        try {
            oText.insertTextContent(oCursor, oFootnote, false);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert the footnote", e);
        }
        XController xController = this.xTextDoc.getCurrentController();
        XViewSettingsSupplier xViewSetSup = UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)xController);
        XPropertySet xPropSet = xViewSetSup.getViewSettings();
        try {
            xPropSet.setPropertyValue("ZoomValue", new Short("10"));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set propertyValue...", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set propertyValue...", e);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set propertyValue...", e);
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set propertyValue...", e);
        }
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)20);
        oObj = AccessibilityTools.SearchedContext;
        log.println("ImplementationName " + utils.getImplName(oObj));
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XPropertySet PropSet = xViewSetSup.getViewSettings();
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    PropSet.setPropertyValue("ZoomValue", new Short("15"));
                    PropSet.setPropertyValue("ZoomValue", new Short("10"));
                }
                catch (WrappedTargetException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (PropertyVetoException e) {
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    // empty catch block
                }
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("dispose text document");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        log.println("creating a text document");
        this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)Param.getMSF());
    }
}

