/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.WriterTools;
import util.utils;

public class SwAccessibleDocumentView
extends TestCase {
    XTextDocument xTextDoc = null;
    public static boolean first = false;
    public static XAccessibleContext SearchedContext = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting some lines");
        try {
            for (int i = 0; i < 5; ++i) {
                oText.insertString(oCursor, "Paragraph Number: " + i, false);
                oText.insertString(oCursor, " The quick brown fox jumps over the lazy Dog: SwXParagraph", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                oText.insertString(oCursor, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG: SwXParagraph", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                oText.insertControlCharacter(oCursor, (short)1, false);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert lines", e);
        }
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)13);
        oObj = AccessibilityTools.SearchedContext;
        log.println("ImplementationName " + utils.getImplName(oObj));
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        SwAccessibleDocumentView.getAccessibleObjectForRole(xRoot, (short)50);
        final XAccessibleValue xAccVal = UnoRuntime.queryInterface(XAccessibleValue.class, (Object)SearchedContext);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                xAccVal.setCurrentValue(xAccVal.getMinimumValue());
                xAccVal.setCurrentValue(xAccVal.getMaximumValue());
            }
        });
        return tEnv;
    }

    public static void getAccessibleObjectForRole(XAccessible xacc, short role) {
        XAccessibleContext ac = xacc.getAccessibleContext();
        if (ac.getAccessibleRole() == role) {
            if (first) {
                SearchedContext = ac;
            } else {
                first = true;
            }
        } else {
            int k = ac.getAccessibleChildCount();
            for (int i = 0; i < k; ++i) {
                try {
                    SwAccessibleDocumentView.getAccessibleObjectForRole(ac.getAccessibleChild(i), role);
                    if (SearchedContext == null) continue;
                    return;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("Couldn't get Child");
                }
            }
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("dispose text document");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        log.println("creating a text document");
        this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)Param.getMSF());
    }
}

