/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.WriterTools;
import util.utils;

public class SwAccessibleDocumentPageView
extends TestCase {
    XTextDocument xTextDoc = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        log.println("inserting some lines");
        try {
            for (int i = 0; i < 25; ++i) {
                oText.insertString(oCursor, "Paragraph Number: " + i, false);
                oText.insertString(oCursor, " The quick brown fox jumps over the lazy Dog: SwAccessibleDocumentPageView", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                oText.insertString(oCursor, "THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG: SwAccessibleDocumentPageView", false);
                oText.insertControlCharacter(oCursor, (short)0, false);
                oText.insertControlCharacter(oCursor, (short)1, false);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert lines", e);
        }
        XController xController = this.xTextDoc.getCurrentController();
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        try {
            XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
            XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.util.URLTransformer"));
            URL[] aParseURL = new URL[]{new URL()};
            aParseURL[0].Complete = ".uno:PrintPreview";
            xParser.parseStrict(aParseURL);
            URL aURL = aParseURL[0];
            XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
            if (xDispatcher != null) {
                xDispatcher.dispatch(aURL, null);
            }
        }
        catch (Exception e) {
            log.println("Couldn't change mode");
            throw new StatusException(Status.failed("Couldn't change mode"));
        }
        this.shortWait();
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)13);
        oObj = AccessibilityTools.SearchedContext;
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XText the_text = oText;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                String oldText = the_text.getString();
                the_text.setString("EVENT FIRED");
                SwAccessibleDocumentPageView.this.shortWait();
                the_text.setString(oldText);
            }
        });
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("dispose text document");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        log.println("creating a text document");
        this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)Param.getMSF());
    }
}

