/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class CharacterStyle
extends TestCase {
    XTextDocument xTextDoc;
    SOfficeFactory SOF = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        TestEnvironment tEnv = null;
        XNameAccess oSFNA = null;
        XStyle oStyle = null;
        XStyle oMyStyle = null;
        log.println("creating a test environment");
        try {
            log.println("getting style");
            XStyleFamiliesSupplier oSFS = UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xTextDoc);
            XNameAccess oSF = oSFS.getStyleFamilies();
            XIndexAccess oSFsIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSF);
            oSFNA = UnoRuntime.queryInterface(XNameAccess.class, oSFsIA.getByIndex(0));
            XIndexAccess oSFIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSFNA);
            oStyle = UnoRuntime.queryInterface(XStyle.class, oSFIA.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            log.println("Error: exception occured.");
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Error: exception occured.");
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        try {
            log.print("Creating a user-defined style... ");
            XMultiServiceFactory oMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
            XInterface oInt = (XInterface)oMSF.createInstance("com.sun.star.style.CharacterStyle");
            oMyStyle = UnoRuntime.queryInterface(XStyle.class, (Object)oInt);
        }
        catch (Exception e) {
            log.println("Error: exception occured.");
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        if (oMyStyle == null) {
            log.println("FAILED");
        } else {
            log.println("OK");
        }
        XNameContainer oSFNC = UnoRuntime.queryInterface(XNameContainer.class, (Object)oSFNA);
        try {
            if (oSFNC.hasByName("My Style")) {
                oSFNC.removeByName("My Style");
            }
            oSFNC.insertByName("My Style", oMyStyle);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        catch (ElementExistException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        XText oText = this.xTextDoc.getText();
        XTextCursor oCursor = oText.createTextCursor();
        XPropertySet xProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)oCursor);
        try {
            xProp.setPropertyValue("CharStyleName", oMyStyle.getName());
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create environment ", e);
        }
        log.println("creating a new environment for object");
        tEnv = new TestEnvironment(oMyStyle);
        tEnv.addObjRelation("PoolStyle", oStyle);
        XPropertySet xStyleProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)oMyStyle);
        short exclude = 17;
        tEnv.addObjRelation("PropertyNames", utils.getFilteredPropertyNames(xStyleProp, (short)0, exclude));
        return tEnv;
    }
}

