/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;

public class SvxUnoTextField
extends TestCase {
    static XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        try {
            log.println("creating a drawdoc");
            xDrawDoc = DrawTools.createDrawDoc((XMultiServiceFactory)tParam.getMSF());
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(xDrawDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XInterface oObj = null;
        XShape oShape = null;
        log.println("creating a test environment");
        try {
            SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
            oShape = SOF.createShape(xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle");
            DrawTools.getShapes(DrawTools.getDrawPage(xDrawDoc, 0)).add(oShape);
        }
        catch (Exception e) {
            log.println("Couldn't create Shape");
            e.printStackTrace(log);
            throw new StatusException("Couldn't create Shape ", e);
        }
        XTextCursor the_Cursor = null;
        try {
            XText the_Text = UnoRuntime.queryInterface(XText.class, (Object)oShape);
            XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xDrawDoc);
            the_Cursor = the_Text.createTextCursor();
            oObj = (XInterface)oDocMSF.createInstance("com.sun.star.text.TextField.DateTime");
            XTextContent the_Field = UnoRuntime.queryInterface(XTextContent.class, (Object)oObj);
            the_Text.insertTextContent(the_Cursor, the_Field, false);
        }
        catch (Exception ex) {
            log.println("Couldn't create Textfield");
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create TextField ", ex);
        }
        log.println("creating a new environment for FieldMaster object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("RANGE", the_Cursor);
        return tEnv;
    }
}

