/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DefaultDsc;
import util.DesktopTools;
import util.DrawTools;
import util.InstCreator;
import util.SOfficeFactory;

public class SvxUnoText
extends TestCase {
    static XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        try {
            log.println("creating a drawdoc");
            xDrawDoc = DrawTools.createDrawDoc((XMultiServiceFactory)tParam.getMSF());
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(xDrawDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XText oObj = null;
        XTextCursor aRange = null;
        XShape oShape = null;
        try {
            SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
            oShape = SOF.createShape(xDrawDoc, 5000, 3500, 7500, 5000, "Text");
            DrawTools.getShapes(DrawTools.getDrawPage(xDrawDoc, 0)).add(oShape);
            XSimpleText text = UnoRuntime.queryInterface(XSimpleText.class, (Object)oShape);
            XTextCursor cursor = text.createTextCursor();
            text.insertString(cursor, "Paragraph 1", false);
            text.insertControlCharacter(cursor, (short)0, false);
            cursor.setString("TextForMove");
            aRange = cursor;
            XTextCursor cursor1 = text.createTextCursorByRange(text.getEnd());
            text.insertControlCharacter(cursor1, (short)0, false);
            text.insertString(cursor1, "Paragraph 2", false);
            text.insertControlCharacter(cursor1, (short)0, false);
            text.insertString(cursor1, "Paragraph 3", false);
            text.insertControlCharacter(cursor1, (short)0, false);
            oObj = text.getText();
        }
        catch (Exception e) {
            log.println("Can't create test object");
            e.printStackTrace(log);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        DefaultDsc tDsc = new DefaultDsc("com.sun.star.text.XTextContent", "com.sun.star.text.TextField.DateTime");
        log.println("    adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(xDrawDoc, tDsc));
        tEnv.addObjRelation("RangeForMove", aRange);
        tEnv.addObjRelation("XTextRange", oObj);
        tEnv.addObjRelation("TEXT", UnoRuntime.queryInterface(XText.class, (Object)oShape));
        return tEnv;
    }
}

