/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.PolyPolygonBezierCoords;
import com.sun.star.drawing.PolygonFlags;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DefaultDsc;
import util.DesktopTools;
import util.DrawTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.utils;

public class SvxShapePolyPolygonBezier
extends TestCase {
    static XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a chartdocument");
            xDrawDoc = SOF.loadDocument(utils.getFullTestURL("SvxShape.sxd"));
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(xDrawDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XShape oObj = null;
        XShape oShape = null;
        log.println("creating a test environment");
        try {
            SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
            XMultiServiceFactory xMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xDrawDoc);
            XInterface oInst = (XInterface)xMSF.createInstance("com.sun.star.drawing.ClosedBezierShape");
            oShape = UnoRuntime.queryInterface(XShape.class, (Object)oInst);
            Point[] points = new Point[2];
            points[0] = new Point();
            points[0].X = 50;
            points[0].Y = 50;
            points[1] = new Point();
            points[1].X = 5000;
            points[1].Y = 5000;
            Point[][] the_points = new Point[1][2];
            the_points[0] = points;
            PolygonFlags[] flags = new PolygonFlags[]{PolygonFlags.NORMAL, PolygonFlags.NORMAL};
            PolygonFlags[][] the_flags = new PolygonFlags[1][2];
            the_flags[0] = flags;
            PolyPolygonBezierCoords coords = new PolyPolygonBezierCoords();
            coords.Coordinates = the_points;
            coords.Flags = the_flags;
            DrawTools.getShapes(DrawTools.getDrawPage(xDrawDoc, 0)).add(oShape);
            oShape.setSize(new Size(3000, 3000));
            oShape.setPosition(new Point(4000, 4000));
            oObj = oShape;
            XPropertySet shapeProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
            shapeProps.setPropertyValue("PolyPolygonBezier", coords);
            oShape = SOF.createShape(xDrawDoc, 5000, 3500, 7500, 5000, "Line");
            DrawTools.getShapes(DrawTools.getDrawPage(xDrawDoc, 0)).add(oShape);
        }
        catch (Exception e) {
            log.println("Couldn't create instance");
            e.printStackTrace(log);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding two styles as ObjRelation for ShapeDescriptor");
        XPropertySet oShapeProps = UnoRuntime.queryInterface(XPropertySet.class, oObj);
        XStyle aStyle = null;
        try {
            aStyle = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)oShapeProps.getPropertyValue("Style"));
        }
        catch (Exception e) {
            // empty catch block
        }
        tEnv.addObjRelation("Style1", aStyle);
        oShapeProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oShape);
        try {
            aStyle = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)oShapeProps.getPropertyValue("Style"));
        }
        catch (Exception e) {
            // empty catch block
        }
        tEnv.addObjRelation("Style2", aStyle);
        DefaultDsc tDsc = new DefaultDsc("com.sun.star.text.XTextContent", "com.sun.star.text.TextField.URL");
        log.println("    adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(xDrawDoc, tDsc));
        return tEnv;
    }
}

