/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DefaultDsc;
import util.DesktopTools;
import util.DrawTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.utils;

public class SvxShapePolyPolygon
extends TestCase {
    static XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a chartdocument");
            xDrawDoc = SOF.loadDocument(utils.getFullTestURL("SvxShape.sxd"));
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(xDrawDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XShape oObj = null;
        XShape oShape = null;
        log.println("creating a test environment");
        try {
            XMultiServiceFactory xMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xDrawDoc);
            XInterface oInst = (XInterface)xMSF.createInstance("com.sun.star.drawing.PolyPolygonShape");
            oShape = UnoRuntime.queryInterface(XShape.class, (Object)oInst);
            oShape.setSize(new Size(0, 0));
            oShape.setPosition(new Point(0, 0));
            DrawTools.getShapes(DrawTools.getDrawPage(xDrawDoc, 0)).add(oShape);
            Point[] square1 = new Point[]{new Point(5000, 5000), new Point(10000, 5000), new Point(10000, 10000), new Point(5000, 10000)};
            Point[] square2 = new Point[]{new Point(6500, 6500), new Point(8500, 6500), new Point(8500, 8500), new Point(6500, 8500)};
            Point[][] polygon = new Point[][]{square1, square2};
            UnoRuntime.queryInterface(XPropertySet.class, (Object)oShape).setPropertyValue("PolyPolygon", polygon);
            oObj = oShape;
            SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
            oShape = SOF.createShape(xDrawDoc, 5000, 3500, 7500, 5000, "Line");
            DrawTools.getShapes(DrawTools.getDrawPage(xDrawDoc, 0)).add(oShape);
        }
        catch (Exception e) {
            log.println("Couldn't create insance");
            e.printStackTrace(log);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding two styles as ObjRelation for ShapeDescriptor");
        XPropertySet oShapeProps = UnoRuntime.queryInterface(XPropertySet.class, oObj);
        XStyle aStyle = null;
        try {
            aStyle = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)oShapeProps.getPropertyValue("Style"));
        }
        catch (Exception e) {
            // empty catch block
        }
        tEnv.addObjRelation("Style1", aStyle);
        oShapeProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oShape);
        try {
            aStyle = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)oShapeProps.getPropertyValue("Style"));
        }
        catch (Exception e) {
            // empty catch block
        }
        tEnv.addObjRelation("Style2", aStyle);
        DefaultDsc tDsc = new DefaultDsc("com.sun.star.text.XTextContent", "com.sun.star.text.TextField.URL");
        log.println("    adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(xDrawDoc, tDsc));
        return tEnv;
    }
}

