/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapeGrouper;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.ShapeDsc;

public class SvxShapeGroup
extends TestCase {
    static XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a draw document");
            xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xDrawDoc");
        DesktopTools.closeDoc(xDrawDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        XShapes oShapes = null;
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("getting Drawpage");
            XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xDrawDoc);
            XDrawPages oDPn = oDPS.getDrawPages();
            XIndexAccess oDPi = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oDPn);
            oObj = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oDPi.getByIndex(0));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get DrawPage", e);
        }
        if (oObj == null) {
            System.out.println("**************************");
            System.out.println("    XDrawPage is NULL");
            System.out.println("**************************");
        }
        log.println("inserting some Shapes");
        oShapes = UnoRuntime.queryInterface(XShapes.class, (Object)oObj);
        XShape Shape1 = SOF.createShape(xDrawDoc, 3000, 4500, 15000, 1000, "Ellipse");
        oShapes.add(SOF.createShape(xDrawDoc, 2000, 1500, 1000, 1000, "Line"));
        oShapes.add(Shape1);
        XShape Shape2 = SOF.createShape(xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle");
        oShapes.add(Shape2);
        log.println("adding two style as ObjRelation for ShapeDescriptor");
        XPropertySet oShapeProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)Shape1);
        XStyle aStyle1 = null;
        try {
            aStyle1 = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)oShapeProps.getPropertyValue("Style"));
        }
        catch (Exception e) {
            // empty catch block
        }
        oShapeProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)Shape2);
        XStyle aStyle2 = null;
        try {
            aStyle2 = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)oShapeProps.getPropertyValue("Style"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            log.println("get XShapeGroup");
            XShapeGrouper oSG = UnoRuntime.queryInterface(XShapeGrouper.class, (Object)oObj);
            oObj = oSG.group(oShapes);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException(" Couldn't get XShapeGroup: ", e);
        }
        log.println("creating a new environment for drawpage object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        ShapeDsc sDsc = new ShapeDsc(5000, 3500, 7500, 10000, "Rectangle");
        log.println("adding Shape as mod relation to environment");
        tEnv.addObjRelation("Shape", new InstCreator(xDrawDoc, sDsc));
        tEnv.addObjRelation("Style1", aStyle1);
        tEnv.addObjRelation("Style2", aStyle2);
        for (int i = 0; i < 6; ++i) {
            Shape2 = SOF.createShape(xDrawDoc, 5000 + 100 * i, 3500 + 100 * i, 7500 + 100 * i, 5000 + 100 * i, "Rectangle");
            oShapes.add(Shape2);
        }
        return tEnv;
    }
}

