/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.DrawTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.ShapeDsc;
import util.utils;

public class SvxShapeCollection
extends TestCase {
    static XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        try {
            log.println("creating a drawdoc");
            xDrawDoc = DrawTools.createDrawDoc((XMultiServiceFactory)tParam.getMSF());
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(xDrawDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XInterface oObj = null;
        XShape oShape = null;
        log.println("creating a test environment");
        try {
            SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
            Object col = ((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.drawing.ShapeCollection");
            XShapes shapes = UnoRuntime.queryInterface(XShapes.class, col);
            oShape = SOF.createShape(xDrawDoc, 3000, 4500, 15000, 1000, "Ellipse");
            DrawTools.getShapes(DrawTools.getDrawPage(xDrawDoc, 0)).add(oShape);
            shapes.add(oShape);
            oShape = SOF.createShape(xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle");
            DrawTools.getShapes(DrawTools.getDrawPage(xDrawDoc, 0)).add(oShape);
            shapes.add(oShape);
            oObj = (XInterface)col;
        }
        catch (Exception e) {
            log.println("Couldn't create insance");
            e.printStackTrace(log);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        System.out.println("IName: " + utils.getImplName(oObj));
        ShapeDsc sDsc = new ShapeDsc(5000, 3500, 7500, 10000, "Line");
        tEnv.addObjRelation("Shape", new InstCreator(xDrawDoc, sDsc));
        return tEnv;
    }
}

