/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XExporter;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.XMLTools;
import util.utils;

public class GraphicExporter
extends TestCase {
    static XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        log.println("creating a drawdoc");
        xDrawDoc = DrawTools.createDrawDoc((XMultiServiceFactory)tParam.getMSF());
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(xDrawDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XSimpleFileAccess fAcc;
        XInterface oObj = null;
        XShape oShape = null;
        Object go = null;
        log.println("creating a test environment");
        try {
            go = ((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.drawing.GraphicExportFilter");
        }
        catch (Exception e) {
            log.println("Couldn't create instance");
            e.printStackTrace(log);
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        oShape = SOF.createShape(xDrawDoc, 5000, 5000, 1500, 1000, "GraphicObject");
        DrawTools.getShapes(DrawTools.getDrawPage(xDrawDoc, 0)).add(oShape);
        XPropertySet oShapeProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oShape);
        XComponent xComp = null;
        try {
            oShapeProps.setPropertyValue("GraphicURL", utils.getFullTestURL("space-metal.jpg"));
            xComp = UnoRuntime.queryInterface(XComponent.class, (Object)oShape);
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)((XInterface)go));
            xEx.setSourceDocument(xComp);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Error while preparing component", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Error while preparing component", e);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(log);
            throw new StatusException("Error while preparing component", e);
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(log);
            throw new StatusException("Error while preparing component", e);
        }
        final URL aURL = new URL();
        aURL.Complete = utils.getOfficeTemp((XMultiServiceFactory)tParam.getMSF()) + "picture.jpg";
        try {
            Object oFAcc = ((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.ucb.SimpleFileAccess");
            fAcc = UnoRuntime.queryInterface(XSimpleFileAccess.class, oFAcc);
            if (fAcc.exists(aURL.Complete)) {
                fAcc.kill(aURL.Complete);
            }
        }
        catch (Exception e) {
            log.println("Error accessing file system :");
            e.printStackTrace(log);
            throw new StatusException("Error accessing file system.", e);
        }
        oObj = (XInterface)go;
        log.println("ImplName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName", "URL", "MediaType"}, new Object[]{"JPG", aURL, "image/jpeg"}));
        tEnv.addObjRelation("SourceDocument", xComp);
        log.println("adding ObjRelation for XFilter");
        log.println("This Component doesn't really support the cancel method");
        log.println("See #101725");
        tEnv.addObjRelation("NoFilter.cancel()", new Boolean(true));
        final String hideMode = (String)tParam.get("soapi.test.hidewindows");
        tEnv.addObjRelation("XFilter.Checker", new _XFilter.FilterChecker(){

            @Override
            public boolean checkFilter() {
                try {
                    if (hideMode != null && hideMode.equals("true")) {
                        return true;
                    }
                    return fAcc.exists(aURL.Complete);
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        return tEnv;
    }
}

