/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Size;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.utils;

public class AccessiblePresentationShape
extends TestCase {
    static XComponent xDrawDoc;
    static XModel aModel;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a drawdoc");
            xDrawDoc = SOF.createImpressDoc(null);
            aModel = UnoRuntime.queryInterface(XModel.class, (Object)xDrawDoc);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(xDrawDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XAccessibleContext oObj = null;
        XShape oShape = null;
        log.println("creating a test environment");
        XMultiServiceFactory docMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xDrawDoc);
        try {
            oShape = UnoRuntime.queryInterface(XShape.class, docMSF.createInstance("com.sun.star.presentation.HandoutShape"));
        }
        catch (com.sun.star.uno.Exception e) {
            throw new StatusException("couldn't create component", e);
        }
        DrawTools.getShapes(DrawTools.getDrawPage(xDrawDoc, 0)).add(oShape);
        XPropertySet shapeProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oShape);
        try {
            shapeProps.setPropertyValue("IsEmptyPresentationObject", new Boolean(false));
        }
        catch (Exception e) {
            // empty catch block
        }
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)tParam.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)0, "ImpressHandout");
        log.println("Implementation Name: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XShape fShape = oShape;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    Size size = fShape.getSize();
                    size.Width += 100;
                    fShape.setSize(size);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        log.println("Implementation Name: " + utils.getImplName(oObj));
        return tEnv;
    }
}

