/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Size;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.utils;

public class AccessiblePresentationGraphicShape
extends TestCase {
    static XComponent xDoc;
    static XModel aModel;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a drawdoc");
            xDoc = SOF.createImpressDoc(null);
            aModel = UnoRuntime.queryInterface(XModel.class, (Object)xDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(xDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XAccessibleContext oObj = null;
        XShape oShape = null;
        log.println("creating a test environment");
        XMultiServiceFactory docMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xDoc);
        try {
            oShape = UnoRuntime.queryInterface(XShape.class, docMSF.createInstance("com.sun.star.presentation.GraphicObjectShape"));
        }
        catch (Exception e) {
            throw new StatusException("couldn't create component", e);
        }
        DrawTools.getShapes(DrawTools.getDrawPage(xDoc, 0)).add(oShape);
        XPropertySet oShapeProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oShape);
        try {
            oShapeProps.setPropertyValue("GraphicURL", utils.getFullTestURL("space-metal.jpg"));
            oShapeProps.setPropertyValue("IsEmptyPresentationObject", new Boolean(false));
        }
        catch (WrappedTargetException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (PropertyVetoException e) {
        }
        catch (UnknownPropertyException e) {
            // empty catch block
        }
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)tParam.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)0, "GraphicObject");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XShape fShape = oShape;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    Size size = fShape.getSize();
                    size.Width += 100;
                    fShape.setSize(size);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        log.println("Implementation Name: " + utils.getImplName(oObj));
        return tEnv;
    }
}

