/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.utils;

public class AccessiblePageShape
extends TestCase {
    static XComponent xDrawDoc;
    static XModel aModel;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a drawdoc");
            xDrawDoc = SOF.createDrawDoc(null);
            aModel = UnoRuntime.queryInterface(XModel.class, (Object)xDrawDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(xDrawDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XAccessibleContext oObj = null;
        XDrawPage oPage = null;
        log.println("creating a test environment");
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)tParam.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)0, "PageShape");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        oPage = DrawTools.getDrawPage(xDrawDoc, 0);
        final XPropertySet PageProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oPage);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    PageProps.setPropertyValue("Height", new Integer(5000));
                }
                catch (UnknownPropertyException upe) {
                    System.out.println("Don't no the Property Height");
                }
                catch (PropertyVetoException pve) {
                    System.out.println("PropertyVetoException Exception while changing Height");
                }
                catch (IllegalArgumentException iae) {
                    System.out.println("IllegalArgumentException Exception while changing Height");
                }
                catch (WrappedTargetException wte) {
                    System.out.println("WrappedTargetException Exception while changing Height");
                }
            }
        });
        log.println("Implementation Name: " + utils.getImplName(oObj));
        return tEnv;
    }
}

