/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleEditableTextPara
extends TestCase {
    static XComponent xSpreadsheetDoc = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessible oObj = null;
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        XAccessibleContext InputLine = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)61, "Input line");
        try {
            oObj = InputLine.getAccessibleChild(0);
            XAccessibleEditableText et = UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)oObj);
            et.setText("AccessibleEditablePara");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XAccessibleEditableText edText = UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)oObj);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    int l = new String("AccessibleEditablePara").length();
                    edText.deleteText(0, l);
                    edText.setText("Event");
                    edText.setText("AccessibleEditablePara");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        DesktopTools.closeDoc(xSpreadsheetDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a spreadsheetdocument");
            xSpreadsheetDoc = UnoRuntime.queryInterface(XComponent.class, (Object)SOF.createCalcDoc(null));
            this.shortWait();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document ", e);
        }
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

