/*
 * Decompiled with CFR 0.152.
 */
package mod._svtools;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.container.XNameAccess;
import com.sun.star.drawing.XLayerManager;
import com.sun.star.drawing.XLayerSupplier;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleTabBarPageList
extends TestCase {
    static XComponent xDoc;

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xDoc");
        if (xDoc != null) {
            this.closeDoc();
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        if (xDoc != null) {
            this.closeDoc();
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a draw document");
            xDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.shortWait();
        XInterface oObj = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        AccessibilityTools at = new AccessibilityTools();
        this.shortWait();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)39);
        log.println("ImplementationName: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XAccessibleSelection.multiSelection", new Boolean(false));
        tEnv.addObjRelation("XAccessibleSelection.OneAlwaysSelected", new Boolean(true));
        XLayerSupplier oLS = UnoRuntime.queryInterface(XLayerSupplier.class, (Object)xDoc);
        XNameAccess oLM = oLS.getLayerManager();
        final XLayerManager xLM = UnoRuntime.queryInterface(XLayerManager.class, (Object)oLM);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                xLM.insertNewByIndex(0);
            }
        });
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }

    protected void closeDoc() {
        XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)xDoc);
        try {
            closer.close(true);
        }
        catch (CloseVetoException e) {
            this.log.println("Couldn't close document " + e.getMessage());
        }
        catch (DisposedException e) {
            this.log.println("Couldn't close document " + e.getMessage());
        }
    }
}

