/*
 * Decompiled with CFR 0.152.
 */
package mod._svtools;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleTabBarPage
extends TestCase {
    static XComponent xDoc;

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xCalcDoc");
        if (xDoc != null) {
            DesktopTools.closeDoc(xDoc);
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        if (xDoc != null) {
            xDoc.dispose();
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a calc document");
            xDoc = UnoRuntime.queryInterface(XComponent.class, (Object)SOF.createCalcDoc(null));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.shortWait();
        XInterface oObj = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        AccessibilityTools at = new AccessibilityTools();
        this.shortWait();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)38, "Sheet1");
        XAccessibleContext acc = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)38, "Sheet2");
        XAccessibleComponent accComp = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)acc);
        final Point point = accComp.getLocationOnScreen();
        log.println("ImplementationName: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("Destroy", "yes");
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    Robot rob = new Robot();
                    rob.mouseMove(point.X + 25, point.Y + 5);
                    rob.mousePress(16);
                }
                catch (AWTException e) {
                    System.out.println("couldn't fire event");
                }
            }
        });
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }
}

