/*
 * Decompiled with CFR 0.152.
 */
package mod._svtools;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleTabBar
extends TestCase {
    static XComponent xDoc;

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xCalcDoc");
        if (xDoc != null) {
            this.closeDoc(xDoc);
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        if (xDoc != null) {
            this.closeDoc(xDoc);
        }
        XMultiServiceFactory msf = (XMultiServiceFactory)tParam.getMSF();
        SOfficeFactory SOF = SOfficeFactory.getFactory(msf);
        try {
            log.println("creating a calc document");
            xDoc = UnoRuntime.queryInterface(XComponent.class, (Object)SOF.createCalcDoc(null));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.shortWait();
        XInterface oObj = null;
        try {
            oObj = (XInterface)msf.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        AccessibilityTools at = new AccessibilityTools();
        this.shortWait();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)40);
        log.println("ImplementationName: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XWindow aWin = xWindow;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                aWin.setPosSize(100, 100, 500, 500, (short)15);
            }
        });
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }

    protected void closeDoc(XComponent xDoc) {
        XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)xDoc);
        try {
            closer.close(true);
        }
        catch (CloseVetoException e) {
            this.log.println("Couldn't close document " + e.getMessage());
        }
        catch (NullPointerException e) {
            this.log.println("Couldn't close document " + e.getMessage());
        }
    }
}

