/*
 * Decompiled with CFR 0.152.
 */
package mod._svtools;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.awt.Point;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.view.XSelectionSupplier;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleBrowseBoxHeaderBar
extends TestCase {
    static XDesktop the_Desk;
    static XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xTextDoc");
        if (xTextDoc != null) {
            xTextDoc.dispose();
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        if (xTextDoc != null) {
            xTextDoc.dispose();
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a text document");
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.shortWait();
        XModel aModel1 = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XController secondController = aModel1.getCurrentController();
        XDispatchProvider aProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)secondController);
        XDispatch getting = null;
        log.println("opening DatasourceBrowser");
        URL the_url = new URL();
        the_url.Complete = ".component:DB/DataSourceBrowser";
        getting = aProv.queryDispatch(the_url, "_beamer", 12);
        PropertyValue[] noArgs = new PropertyValue[]{};
        getting.dispatch(the_url, noArgs);
        PropertyValue[] params = new PropertyValue[3];
        PropertyValue param1 = new PropertyValue();
        param1.Name = "DataSourceName";
        param1.Value = "Bibliography";
        params[0] = param1;
        PropertyValue param2 = new PropertyValue();
        param2.Name = "CommandType";
        param2.Value = new Integer(0);
        params[1] = param2;
        PropertyValue param3 = new PropertyValue();
        param3.Name = "Command";
        param3.Value = "biblio";
        params[2] = param3;
        this.shortWait();
        XFrame the_frame1 = the_Desk.getCurrentFrame();
        if (the_frame1 == null) {
            log.println("Current frame was not found !!!");
        }
        XFrame the_frame2 = the_frame1.findFrame("_beamer", 4);
        the_frame2.setName("DatasourceBrowser");
        XController xCont = the_frame2.getController();
        XSelectionSupplier xSelect = UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xCont);
        try {
            xSelect.select(params);
        }
        catch (IllegalArgumentException ex) {
            throw new StatusException("Could not select Biblio-Database", ex);
        }
        XInterface oObj = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)58);
        AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        log.println("ImplementationName: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        this.shortWait();
        XAccessibleComponent accComp = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)oObj);
        final Point point = accComp.getLocationOnScreen();
        this.shortWait();
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    Robot rob = new Robot();
                    rob.mouseMove(point.X + 5, point.Y + 5);
                    rob.mousePress(16);
                }
                catch (AWTException e) {
                    System.out.println("couldn't fire event");
                }
            }
        });
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }
}

