/*
 * Decompiled with CFR 0.152.
 */
package mod._svtools;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.view.XSelectionSupplier;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleBrowseBox
extends TestCase {
    static XDesktop the_Desk;
    static XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xTextDoc");
        if (xTextDoc != null) {
            xTextDoc.dispose();
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        if (xTextDoc != null) {
            xTextDoc.dispose();
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a text document");
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.shortWait();
        XModel aModel1 = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XController secondController = aModel1.getCurrentController();
        XDispatchProvider aProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)secondController);
        XDispatch getting = null;
        log.println("opening DatasourceBrowser");
        URL the_url = new URL();
        the_url.Complete = ".component:DB/DataSourceBrowser";
        getting = aProv.queryDispatch(the_url, "_beamer", 12);
        PropertyValue[] noArgs = new PropertyValue[]{};
        getting.dispatch(the_url, noArgs);
        this.shortWait();
        XFrame the_frame1 = the_Desk.getCurrentFrame();
        if (the_frame1 == null) {
            log.println("Current frame was not found !!!");
        }
        XFrame the_frame2 = the_frame1.findFrame("_beamer", 4);
        the_frame2.setName("DatasourceBrowser");
        XInterface oObj = null;
        final XSelectionSupplier xSelect = UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)the_frame2.getController());
        PropertyValue[] params = new PropertyValue[]{new PropertyValue(), new PropertyValue(), new PropertyValue()};
        params[0].Name = "DataSourceName";
        params[0].Value = "Bibliography";
        params[1].Name = "CommandType";
        params[1].Value = new Integer(0);
        params[2].Name = "Command";
        params[2].Value = "biblio";
        final PropertyValue[] fParams = params;
        this.shortWait();
        try {
            oObj = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)40, "", "AccessibleBrowseBox");
        log.println("ImplementationName: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    xSelect.select(fParams);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }
}

