/*
 * Decompiled with CFR 0.152.
 */
package mod._streams.uno;

import com.sun.star.io.XActiveDataSink;
import com.sun.star.io.XActiveDataSource;
import com.sun.star.io.XDataOutputStream;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.util.Vector;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

public class DataInputStream
extends TestCase {
    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        Object oInterface = null;
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        try {
            oInterface = xMSF.createInstance("com.sun.star.io.DataInputStream");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instance", e);
        }
        XInterface oObj = (XInterface)oInterface;
        XActiveDataSink xDataSink = UnoRuntime.queryInterface(XActiveDataSink.class, (Object)oObj);
        XInterface oPipe = null;
        try {
            oPipe = (XInterface)xMSF.createInstance("com.sun.star.io.Pipe");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instance", e);
        }
        XInputStream xPipeInput = UnoRuntime.queryInterface(XInputStream.class, (Object)oPipe);
        XOutputStream xPipeOutput = UnoRuntime.queryInterface(XOutputStream.class, (Object)oPipe);
        XInterface oDataOutput = null;
        try {
            oDataOutput = (XInterface)xMSF.createInstance("com.sun.star.io.DataOutputStream");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instance", e);
        }
        XDataOutputStream xDataOutput = UnoRuntime.queryInterface(XDataOutputStream.class, (Object)oDataOutput);
        XActiveDataSource xDataSource = UnoRuntime.queryInterface(XActiveDataSource.class, (Object)oDataOutput);
        xDataSource.setOutputStream(xPipeOutput);
        xDataSink.setInputStream(xPipeInput);
        Vector<Object> data = new Vector<Object>();
        data.add(new Boolean(true));
        data.add(new Byte(123));
        data.add(new Character('\u04d2'));
        data.add(new Short(1234));
        data.add(new Integer(123456));
        data.add(new Float(1.234));
        data.add(new Double(1.23456));
        data.add("DataInputStream");
        byte[] byteData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        XInterface xConnect = null;
        try {
            xConnect = (XInterface)xMSF.createInstance("com.sun.star.io.DataInputStream");
        }
        catch (Exception e) {
            log.println("Can't create DataInputStream");
            e.printStackTrace(log);
            throw new StatusException("Can't create DataInputStream", e);
        }
        XInterface oDataInput = null;
        try {
            oDataInput = (XInterface)xMSF.createInstance("com.sun.star.io.Pipe");
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Can't create new in stream");
            e.printStackTrace(log);
            throw new StatusException("Can't create input stream", e);
        }
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("StreamData", data);
        tEnv.addObjRelation("StreamWriter", xDataOutput);
        tEnv.addObjRelation("Connectable", xConnect);
        tEnv.addObjRelation("InputStream", oDataInput);
        tEnv.addObjRelation("ByteData", byteData);
        return tEnv;
    }
}

