/*
 * Decompiled with CFR 0.152.
 */
package mod._stm;

import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XActiveDataSink;
import com.sun.star.io.XActiveDataSource;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

public class Pump
extends TestCase {
    @Override
    public TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XInterface oPipe;
        Object oInterface = null;
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        try {
            oInterface = xMSF.createInstance("com.sun.star.io.Pump");
            oPipe = (XInterface)xMSF.createInstance("com.sun.star.io.Pipe");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create the needed objects.", e);
        }
        XInterface oObj = (XInterface)oInterface;
        XActiveDataSink xSink = UnoRuntime.queryInterface(XActiveDataSink.class, (Object)oObj);
        XActiveDataSource xSource = UnoRuntime.queryInterface(XActiveDataSource.class, (Object)oObj);
        MyInput xInput = new MyInput();
        MyOutput xOutput = new MyOutput();
        xSink.setInputStream(xInput);
        xSource.setOutputStream(xOutput);
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("InputStream", oPipe);
        tEnv.addObjRelation("OutputStream", oPipe);
        return tEnv;
    }

    private static class MyOutput
    implements XOutputStream {
        private MyOutput() {
        }

        @Override
        public void writeBytes(byte[] bytes) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void closeOutput() {
        }
    }

    private static class MyInput
    implements XInputStream {
        String str = "Pump tesing string";

        private MyInput() {
        }

        @Override
        public int readBytes(byte[][] bytes, int len) throws NotConnectedException {
            if (this.str == null) {
                throw new NotConnectedException("Input stream was closed");
            }
            int actual = 0;
            if (len <= this.str.length()) {
                String resStr = this.str.substring(0, len - 1);
                bytes[0] = resStr.getBytes();
                actual = len;
                this.str = this.str.substring(len);
            } else {
                bytes[0] = this.str.getBytes();
                actual = this.str.length();
            }
            return actual;
        }

        @Override
        public int readSomeBytes(byte[][] bytes, int len) throws NotConnectedException {
            return this.readBytes(bytes, len);
        }

        @Override
        public void skipBytes(int len) throws NotConnectedException {
            if (this.str == null) {
                throw new NotConnectedException("Stream was closed.");
            }
            this.str = len >= this.str.length() ? "" : this.str.substring(len);
        }

        @Override
        public void closeInput() throws NotConnectedException {
            if (this.str == null) {
                throw new NotConnectedException("Stream was closed.");
            }
            this.str = null;
        }

        @Override
        public int available() throws NotConnectedException {
            if (this.str == null) {
                throw new NotConnectedException("Stream was closed.");
            }
            return this.str.length();
        }
    }
}

