/*
 * Decompiled with CFR 0.152.
 */
package mod._stm;

import com.sun.star.io.IOException;
import com.sun.star.io.XActiveDataSink;
import com.sun.star.io.XActiveDataSource;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XObjectInputStream;
import com.sun.star.io.XObjectOutputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XPersistObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.CannotRegisterImplementationException;
import com.sun.star.registry.XImplementationRegistration;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.io._XOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class ObjectOutputStream
extends TestCase {
    @Override
    public void initialize(TestParameters tParam, PrintWriter log) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        Object oPersObj = null;
        try {
            oPersObj = xMSF.createInstance("com.sun.star.cmp.PersistObject");
        }
        catch (Exception e) {
            log.println("Could not create instance of PersistObject");
            e.printStackTrace(log);
            log.println("Going on with test...");
        }
        if (oPersObj == null) {
            XImplementationRegistration xir;
            String url = utils.getFullTestURL("qadevlibs/MyPersistObjectImpl.jar");
            try {
                Object o = xMSF.createInstance("com.sun.star.registry.ImplementationRegistration");
                xir = UnoRuntime.queryInterface(XImplementationRegistration.class, o);
            }
            catch (Exception e) {
                System.err.println("Couldn't create implementation registration");
                e.printStackTrace();
                throw new StatusException("Couldn't create ImplReg", e);
            }
            XSimpleRegistry xReg = null;
            try {
                System.out.println("Register library: " + url);
                xir.registerImplementation("com.sun.star.loader.Java2", url, xReg);
                System.out.println("...done");
            }
            catch (CannotRegisterImplementationException e) {
                System.err.println("Name: " + url + "  msg: " + e.getMessage());
                e.printStackTrace();
                throw new StatusException("Couldn't register MyPersistObject", e);
            }
        }
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XObjectOutputStream oObj = null;
        XObjectOutputStream oStream = null;
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        Object ostream = null;
        Object istream = null;
        Object aPipe = null;
        Object mostream = null;
        XInterface aConnect = null;
        Object minstream = null;
        try {
            ostream = xMSF.createInstance("com.sun.star.io.ObjectOutputStream");
            istream = xMSF.createInstance("com.sun.star.io.ObjectInputStream");
            aPipe = xMSF.createInstance("com.sun.star.io.Pipe");
            mostream = xMSF.createInstance("com.sun.star.io.MarkableOutputStream");
            aConnect = (XInterface)xMSF.createInstance("com.sun.star.io.DataInputStream");
            minstream = xMSF.createInstance("com.sun.star.io.MarkableInputStream");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instance", e);
        }
        XActiveDataSource xdSo = UnoRuntime.queryInterface(XActiveDataSource.class, ostream);
        XActiveDataSource xdSmo = UnoRuntime.queryInterface(XActiveDataSource.class, mostream);
        XOutputStream moStream = UnoRuntime.queryInterface(XOutputStream.class, mostream);
        XActiveDataSink markIn = UnoRuntime.queryInterface(XActiveDataSink.class, minstream);
        XActiveDataSink inStream = UnoRuntime.queryInterface(XActiveDataSink.class, istream);
        XInputStream markInStream = UnoRuntime.queryInterface(XInputStream.class, minstream);
        final XOutputStream PipeOut = UnoRuntime.queryInterface(XOutputStream.class, aPipe);
        final XInputStream PipeIn = UnoRuntime.queryInterface(XInputStream.class, aPipe);
        markIn.setInputStream(PipeIn);
        inStream.setInputStream(markInStream);
        XObjectInputStream objInputStream = UnoRuntime.queryInterface(XObjectInputStream.class, istream);
        xdSo.setOutputStream(moStream);
        xdSmo.setOutputStream(PipeOut);
        oStream = UnoRuntime.queryInterface(XObjectOutputStream.class, ostream);
        XPersistObject xPersObj = null;
        try {
            Object oPersObj = xMSF.createInstance("com.sun.star.cmp.PersistObject");
            xPersObj = UnoRuntime.queryInterface(XPersistObject.class, oPersObj);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't write persist object.", e);
        }
        oObj = oStream;
        Vector<Object> data = new Vector<Object>();
        data.add(new Boolean(true));
        data.add(new Byte(123));
        data.add(new Character('\u04d2'));
        data.add(new Short(1234));
        data.add(new Integer(123456));
        data.add(new Float(1.234));
        data.add(new Double(1.23456));
        data.add("DataInputStream");
        byte[] byteData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("PersistObject", xPersObj);
        tEnv.addObjRelation("StreamData", data);
        tEnv.addObjRelation("ByteData", byteData);
        tEnv.addObjRelation("OutputStream", aPipe);
        tEnv.addObjRelation("Connectable", aConnect);
        tEnv.addObjRelation("InputStream", objInputStream);
        final XMultiServiceFactory msf = xMSF;
        tEnv.addObjRelation("XOutputStream.StreamChecker", new _XOutputStream.StreamChecker(){
            XInputStream xInStream = null;

            @Override
            public void resetStreams() {
                if (this.xInStream != null) {
                    try {
                        this.xInStream.closeInput();
                        this.xInStream = null;
                    }
                    catch (IOException e) {}
                } else {
                    try {
                        PipeOut.closeOutput();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public XInputStream getInStream() {
                this.resetStreams();
                try {
                    Object oInStream = msf.createInstance("com.sun.star.io.ObjectInputStream");
                    this.xInStream = UnoRuntime.queryInterface(XInputStream.class, oInStream);
                }
                catch (Exception e) {
                    return null;
                }
                XActiveDataSink xDataSink = UnoRuntime.queryInterface(XActiveDataSink.class, (Object)this.xInStream);
                xDataSink.setInputStream(PipeIn);
                return this.xInStream;
            }
        });
        return tEnv;
    }
}

