/*
 * Decompiled with CFR 0.152.
 */
package mod._stm;

import com.sun.star.io.IOException;
import com.sun.star.io.XActiveDataSink;
import com.sun.star.io.XActiveDataSource;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.io._XOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

public class MarkableOutputStream
extends TestCase {
    @Override
    public TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XInterface aConnect;
        XInterface oObj = null;
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        Object aPipe = null;
        Object mostream = null;
        Object mistream = null;
        try {
            aPipe = xMSF.createInstance("com.sun.star.io.Pipe");
            mistream = xMSF.createInstance("com.sun.star.io.MarkableInputStream");
            mostream = xMSF.createInstance("com.sun.star.io.MarkableOutputStream");
            aConnect = (XInterface)xMSF.createInstance("com.sun.star.io.DataOutputStream");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instance", e);
        }
        XActiveDataSource xdSmo = UnoRuntime.queryInterface(XActiveDataSource.class, mostream);
        final XOutputStream PipeOut = UnoRuntime.queryInterface(XOutputStream.class, aPipe);
        final XInputStream PipeIn = UnoRuntime.queryInterface(XInputStream.class, aPipe);
        xdSmo.setOutputStream(PipeOut);
        XActiveDataSink xmSi = UnoRuntime.queryInterface(XActiveDataSink.class, mistream);
        xmSi.setInputStream(PipeIn);
        oObj = (XInterface)mostream;
        Vector<Object> data = new Vector<Object>();
        data.add(new Boolean(true));
        data.add(new Byte(123));
        data.add(new Character('\u04d2'));
        data.add(new Short(1234));
        data.add(new Integer(123456));
        data.add(new Float(1.234));
        data.add(new Double(1.23456));
        data.add("DataInputStream");
        byte[] byteData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("StreamData", data);
        tEnv.addObjRelation("ByteData", byteData);
        tEnv.addObjRelation("OutputStream", aPipe);
        tEnv.addObjRelation("Connectable", aConnect);
        final XMultiServiceFactory msf = xMSF;
        tEnv.addObjRelation("XOutputStream.StreamChecker", new _XOutputStream.StreamChecker(){
            XInputStream xInStream = null;

            @Override
            public void resetStreams() {
                if (this.xInStream != null) {
                    try {
                        this.xInStream.closeInput();
                        this.xInStream = null;
                    }
                    catch (IOException e) {}
                } else {
                    try {
                        PipeOut.closeOutput();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public XInputStream getInStream() {
                this.resetStreams();
                try {
                    Object oInStream = msf.createInstance("com.sun.star.io.MarkableInputStream");
                    this.xInStream = UnoRuntime.queryInterface(XInputStream.class, oInStream);
                }
                catch (Exception e) {
                    return null;
                }
                XActiveDataSink xDataSink = UnoRuntime.queryInterface(XActiveDataSink.class, (Object)this.xInStream);
                xDataSink.setInputStream(PipeIn);
                return this.xInStream;
            }
        });
        return tEnv;
    }
}

