/*
 * Decompiled with CFR 0.152.
 */
package mod._sm;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLSettingsImporter
extends TestCase {
    XComponent xMathDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            this.xMathDoc = SOF.openDoc("smath", "_blank");
        }
        catch (Exception ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create document", ex);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xMathDoc ");
        this.xMathDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        XInterface oObj = null;
        int impMargin = 67;
        try {
            oObj = (XInterface)xMSF.createInstance("com.sun.star.comp.Math.XMLSettingsImporter");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Unexpected exception", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xMathDoc);
        String[][] xml = new String[][]{{"start", "office:document-settings", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:config", "CDATA", "http://openoffice.org/2001/config", "xmlns:xlink", "CDATA", "http://www.w3.org/1999/xlink", "office:version", "CDATA", "1.0"}, {"start", "office:settings"}, {"start", "config:config-item-set", "config:name", "CDATA", "configuration-settings"}, {"start", "config:config-item", "config:name", "CDATA", "TopMargin", "config:type", "CDATA", "short"}, {"chars", String.valueOf(67)}, {"end", "config:config-item"}, {"end", "config:config-item-set"}, {"end", "office:settings"}, {"end", "office:document-settings"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        final PrintWriter logF = log;
        final XPropertySet xPS = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xMathDoc);
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                try {
                    Short gMargin = (Short)xPS.getPropertyValue("TopMargin");
                    logF.println("Margin returned: " + gMargin);
                    return 67 == gMargin;
                }
                catch (Exception e) {
                    logF.println("Exception occured while checking filter :");
                    e.printStackTrace(logF);
                    return false;
                }
            }
        });
        return tEnv;
    }
}

