/*
 * Decompiled with CFR 0.152.
 */
package mod._sm;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLMetaImporter
extends TestCase {
    XComponent xMathDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            this.xMathDoc = SOF.openDoc("smath", "_blank");
        }
        catch (Exception ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create document", ex);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xMathDoc ");
        this.xMathDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XDocumentInfoSupplier xDocInfoSup;
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        XInterface oObj = null;
        String impName = "XMLMetaImporter";
        String impValue = "XMLMetaImporter_Value";
        String impTitle = "XMLMetaImporter Title";
        try {
            oObj = (XInterface)xMSF.createInstance("com.sun.star.comp.Math.XMLMetaImporter");
            xDocInfoSup = UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)this.xMathDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Unexpected exception", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xMathDoc);
        String[][] xml = new String[][]{{"start", "office:document-meta", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:meta", "CDATA", "http://openoffice.org/2000/meta", "xmlns:xlink", "CDATA", "http://www.w3.org/1999/xlink", "xmlns:dc", "CDATA", "http://purl.org/dc/elements/1.1/"}, {"start", "office:meta"}, {"start", "dc:title"}, {"chars", "XMLMetaImporter Title"}, {"end", "dc:title"}, {"start", "meta:user-defined", "meta:name", "CDATA", "XMLMetaImporter"}, {"chars", "XMLMetaImporter_Value"}, {"end", "meta:user-defined"}, {"end", "office:meta"}, {"end", "office:document-meta"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        final PrintWriter logF = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                try {
                    XDocumentInfo xDocInfo = xDocInfoSup.getDocumentInfo();
                    XPropertySet xDocInfoProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)xDocInfo);
                    boolean result = false;
                    for (short i = 0; i < xDocInfo.getUserFieldCount(); i = (short)(i + 1)) {
                        String gName = xDocInfo.getUserFieldName(i);
                        String gValue = xDocInfo.getUserFieldValue(i);
                        logF.println("Field '" + gName + "' = '" + gValue + "'");
                        if (!"XMLMetaImporter".equals(gName) || !"XMLMetaImporter_Value".equals(gValue)) continue;
                        result = true;
                    }
                    String gTitle = (String)xDocInfoProp.getPropertyValue("Title");
                    logF.println("Title returned : '" + gTitle + "'");
                    return result &= "XMLMetaImporter Title".equals(gTitle);
                }
                catch (Exception e) {
                    logF.println("Exception occured while checking filter :");
                    e.printStackTrace(logF);
                    return false;
                }
            }
        });
        return tEnv;
    }
}

