/*
 * Decompiled with CFR 0.152.
 */
package mod._sm;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XModel;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.SOfficeFactory;
import util.utils;

public class SmGraphicAccessible
extends TestCase {
    XComponent xMathDoc;

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            this.xMathDoc = SOF.openDoc("smath", "_blank");
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create document", ex);
        }
        catch (IOException ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create document", ex);
        }
        catch (Exception ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create document", ex);
        }
        String expFormula = "sum a cdot b";
        final XPropertySet xPS = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xMathDoc);
        try {
            xPS.setPropertyValue("Formula", "sum a cdot b");
        }
        catch (WrappedTargetException e) {
            log.println("Couldn't set property value");
            e.printStackTrace(log);
        }
        catch (IllegalArgumentException e) {
            log.println("Couldn't set property value");
            e.printStackTrace(log);
        }
        catch (PropertyVetoException e) {
            log.println("Couldn't set property value");
            e.printStackTrace(log);
        }
        catch (UnknownPropertyException e) {
            log.println("Couldn't set property value");
            e.printStackTrace(log);
        }
        XAccessibleContext oObj = null;
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xMathDoc);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)13, "Formula");
        log.println("ImplementationName " + utils.getImplName(oObj));
        final XAccessibleComponent xAC = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)oObj);
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("EditOnly", "This method isn't supported in this dialog");
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    xAC.grabFocus();
                    xPS.setPropertyValue("Formula", "sum hat x");
                    SmGraphicAccessible.this.shortWait();
                    xPS.setPropertyValue("Formula", "sum a cdot b");
                    SmGraphicAccessible.this.shortWait();
                }
                catch (WrappedTargetException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (PropertyVetoException e) {
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    // empty catch block
                }
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    disposing xMathDoc ");
        this.xMathDoc.dispose();
    }

    private void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

