/*
 * Decompiled with CFR 0.152.
 */
package mod._sm;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XModel;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.SOfficeFactory;
import util.utils;

public class SmEditAccessible
extends TestCase {
    XComponent xMathDoc;

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            this.xMathDoc = SOF.openDoc("smath", "_blank");
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create document", ex);
        }
        catch (IOException ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create document", ex);
        }
        catch (Exception ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't create document", ex);
        }
        String expFormula = "sum hat a";
        final XPropertySet xPS = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xMathDoc);
        try {
            xPS.setPropertyValue("Formula", "sum hat a");
        }
        catch (WrappedTargetException e) {
            log.println("Couldn't set property value");
            e.printStackTrace(log);
        }
        catch (IllegalArgumentException e) {
            log.println("Couldn't set property value");
            e.printStackTrace(log);
        }
        catch (PropertyVetoException e) {
            log.println("Couldn't set property value");
            e.printStackTrace(log);
        }
        catch (UnknownPropertyException e) {
            log.println("Couldn't set property value");
            e.printStackTrace(log);
        }
        XAccessibleContext oObj = null;
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xMathDoc);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)40, "", "SmEditAccessible");
        log.println("ImplementationName " + utils.getImplName(oObj));
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("Destroy", new Boolean(true));
        final XAccessibleContext con = UnoRuntime.queryInterface(XAccessibleContext.class, (Object)oObj);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    System.out.println("Childs " + con.getAccessibleChildCount());
                    xPS.setPropertyValue("Formula", "sum hat x \n int a \n sum b");
                    SmEditAccessible.this.shortWait();
                    System.out.println("Childs " + con.getAccessibleChildCount());
                    xPS.setPropertyValue("Formula", "sum hat a");
                    SmEditAccessible.this.shortWait();
                }
                catch (WrappedTargetException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (PropertyVetoException e) {
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    // empty catch block
                }
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    disposing xMathDoc ");
        this.xMathDoc.dispose();
    }

    private void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

