/*
 * Decompiled with CFR 0.152.
 */
package mod._simplereg.uno;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class SimpleRegistry
extends TestCase {
    protected void copyFile(String src, String dst, PrintWriter log) throws IOException {
        File srcF = new File(src);
        File dstF = new File(dst);
        System.out.println("H1");
        if (dstF.exists()) {
            dstF.delete();
        }
        System.out.println("H2");
        dstF.createNewFile();
        dstF.deleteOnExit();
        System.out.println("H3");
        FileInputStream fIn = new FileInputStream(srcF);
        System.out.println("H4");
        FileOutputStream fOut = new FileOutputStream(dstF);
        byte[] buf = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = fIn.read(buf)) > 0) {
            fOut.write(buf, 0, bytesRead);
        }
        fIn.close();
        fOut.close();
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        Object oInterface = null;
        String tmpDir = utils.getOfficeTempDirSys((XMultiServiceFactory)Param.getMSF());
        String openF = "XSimpleRegistry_open.rdb";
        String destroyF = "XSimpleRegistry_destroy.rdb";
        String mergeF = "XSimpleRegistry_merge.rdb";
        try {
            XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
            oInterface = xMSF.createInstance("com.sun.star.registry.SimpleRegistry");
        }
        catch (Exception e) {
            log.println("Service not available");
        }
        if (oInterface == null) {
            log.println("Service wasn't created");
        }
        oObj = (XInterface)oInterface;
        log.println("creating copies of the registry for XSimpleRegistry");
        try {
            String source = utils.getFullTestDocName("XSimpleRegistry.rdb");
            this.copyFile(source, tmpDir + "XSimpleRegistry_open.rdb", log);
            this.copyFile(source, tmpDir + "XSimpleRegistry_destroy.rdb", log);
            this.copyFile(source, tmpDir + "XSimpleRegistry_merge.rdb", log);
        }
        catch (IOException e) {
            log.println("Exception occured while copying files");
            e.printStackTrace(log);
        }
        log.println("    creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XSimpleRegistry.open", tmpDir + "XSimpleRegistry_open.rdb");
        tEnv.addObjRelation("XSimpleRegistry.destroy", tmpDir + "XSimpleRegistry_destroy.rdb");
        tEnv.addObjRelation("XSimpleRegistry.merge", tmpDir + "XSimpleRegistry_merge.rdb");
        return tEnv;
    }
}

