/*
 * Decompiled with CFR 0.152.
 */
package mod._shlibloader.uno;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class DLLComponentLoader
extends TestCase {
    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        Object oInterface = null;
        XMultiServiceFactory xMSF = null;
        try {
            xMSF = (XMultiServiceFactory)Param.getMSF();
            oInterface = xMSF.createInstance("com.sun.star.comp.stoc.DLLComponentLoader");
        }
        catch (Exception e) {
            log.println("DLLComponentLoader Service not available");
        }
        oObj = (XInterface)oInterface;
        log.println("    creating a new environment for DLLComponentLoader object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("ImplementationLoader", "com.sun.star.loader.SharedLibrary");
        String os = (String)Param.get("OS");
        if (os == null || os == "") {
            throw new StatusException("Couldn't determine operating system for naming convention.", new NullPointerException());
        }
        String name = "javaloader.uno";
        name = !os.equals("wntmsci") ? name + ".so" : name + ".dll";
        String implURL = utils.getOfficeURL(xMSF) + "/" + name;
        tEnv.addObjRelation("ImplementationUrl", implURL);
        log.println("looking for shared lib: " + implURL);
        tEnv.addObjRelation("ImplementationName", "com.sun.star.comp.stoc.JavaComponentLoader");
        return tEnv;
    }
}

