/*
 * Decompiled with CFR 0.152.
 */
package mod._servicemgr.uno;

import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XSet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

public class OServiceManager
extends TestCase {
    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        Object oInterface = null;
        try {
            XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
            oInterface = xMSF.createInstance("com.sun.star.comp.stoc.OServiceManager");
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("ServiceManager service not available");
        }
        Object newElement = null;
        XMultiServiceFactory srvMan = null;
        XComponentContext xContext = null;
        try {
            srvMan = Bootstrap.createSimpleServiceManager();
        }
        catch (Exception ex) {
            log.println("Error creating SimpleServiceManager :");
            ex.printStackTrace(log);
        }
        try {
            XSet set = UnoRuntime.queryInterface(XSet.class, oInterface);
            XSet set1 = UnoRuntime.queryInterface(XSet.class, (Object)srvMan);
            XEnumeration oEnum = set1.createEnumeration();
            Object srv = oEnum.nextElement();
            set.insert(srv);
            newElement = oEnum.nextElement();
            XPropertySet xProp = UnoRuntime.queryInterface(XPropertySet.class, oInterface);
            if (xProp != null) {
                xContext = (XComponentContext)AnyConverter.toObject((Type)new Type(XComponentContext.class), (Object)xProp.getPropertyValue("DefaultContext"));
            }
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Can't insert a service to the ServiceManager");
            throw new StatusException("Can't create object environment", e);
        }
        oObj = (XInterface)oInterface;
        log.println("    creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("NewElement", newElement);
        tEnv.addObjRelation("PTT", new String[]{"DefaultContext", "none", "none"});
        if (xContext != null) {
            tEnv.addObjRelation("DC", xContext);
        }
        return tEnv;
    }
}

