/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.presentation.XCustomPresentationSupplier;
import com.sun.star.presentation.XPresentation;
import com.sun.star.presentation.XPresentationSupplier;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SdXPresentation
extends TestCase {
    XComponent xImpressDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a draw document");
            this.xImpressDoc = SOF.createImpressDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xImpressDoc");
        DesktopTools.closeDoc(this.xImpressDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        log.println("creating a test environment");
        log.println("get presentation");
        XPresentationSupplier oPS = UnoRuntime.queryInterface(XPresentationSupplier.class, (Object)this.xImpressDoc);
        XPresentation oObj = oPS.getPresentation();
        log.println("get custom presentation");
        XCustomPresentationSupplier oCPS = UnoRuntime.queryInterface(XCustomPresentationSupplier.class, (Object)this.xImpressDoc);
        XNameContainer xCP = oCPS.getCustomPresentations();
        XInterface oInstance = null;
        XInterface oInstance2 = null;
        XSingleServiceFactory oSingleMSF = UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)xCP);
        try {
            oInstance = (XInterface)oSingleMSF.createInstance();
            oInstance2 = (XInterface)oSingleMSF.createInstance();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instance", e);
        }
        try {
            xCP.insertByName("FirstPresentation", oInstance);
            xCP.insertByName("SecondPresentation", oInstance2);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert Instance", e);
        }
        catch (ElementExistException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert Instance", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert Instance", e);
        }
        log.println("creating a new environment for XPresentation object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("Presentation", oObj);
        return tEnv;
    }
}

