/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.FillStyle;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;
import ifc.view._XPrintJobBroadcaster;
import java.io.File;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.utils;

public class SdXImpressDocument
extends TestCase {
    XComponent xImpressDoc;
    XComponent xImpressDoc2;

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xImpressDoc");
        DesktopTools.closeDoc(this.xImpressDoc);
        DesktopTools.closeDoc(this.xImpressDoc2);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating two impress documents");
            this.xImpressDoc2 = SOF.createImpressDoc(null);
            this.xImpressDoc = SOF.createImpressDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create documents", e);
        }
        XModel xModel1 = UnoRuntime.queryInterface(XModel.class, (Object)this.xImpressDoc);
        XModel xModel2 = UnoRuntime.queryInterface(XModel.class, (Object)this.xImpressDoc2);
        XController cont1 = xModel1.getCurrentController();
        XController cont2 = xModel2.getCurrentController();
        cont1.getFrame().setName("cont1");
        cont2.getFrame().setName("cont2");
        XSelectionSupplier sel = UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)cont1);
        XShape aShape = SOF.createShape(this.xImpressDoc, 5000, 3500, 7500, 5000, "Rectangle");
        XPropertySet xShapeProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)aShape);
        try {
            xShapeProps.setPropertyValue("FillStyle", FillStyle.SOLID);
            xShapeProps.setPropertyValue("FillTransparence", new Integer(50));
        }
        catch (UnknownPropertyException ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't make shape transparent", ex);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't make shape transparent", ex);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't make shape transparent", ex);
        }
        catch (WrappedTargetException ex) {
            ex.printStackTrace(log);
            throw new StatusException("Couldn't make shape transparent", ex);
        }
        DrawTools.getDrawPage(this.xImpressDoc, 0).add(aShape);
        log.println("creating a new environment for drawpage object");
        TestEnvironment tEnv = new TestEnvironment(this.xImpressDoc);
        log.println("adding Controller as ObjRelation for XModel");
        tEnv.addObjRelation("CONT2", cont2);
        log.println("Adding SelectionSupplier and Shape to select for XModel");
        tEnv.addObjRelation("SELSUPP", sel);
        tEnv.addObjRelation("TOSELECT", aShape);
        String fileName = utils.getOfficeTempDirSys((XMultiServiceFactory)Param.getMSF()) + "printfile.prt";
        File f = new File(fileName);
        if (f.exists()) {
            f.delete();
        }
        _XPrintJobBroadcaster.MyPrintJobListener listener = new _XPrintJobBroadcaster.MyPrintJobListener(this.xImpressDoc, fileName);
        tEnv.addObjRelation("XPrintJobBroadcaster.XPrintJobListener", listener);
        return tEnv;
    }
}

