/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.presentation.XCustomPresentationSupplier;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SdXCustomPresentationAccess
extends TestCase {
    XComponent xImpressDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a draw document");
            this.xImpressDoc = SOF.createImpressDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xImpressDoc");
        DesktopTools.closeDoc(this.xImpressDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        log.println("creating a test environment");
        log.println("get presentation");
        XCustomPresentationSupplier oPS = UnoRuntime.queryInterface(XCustomPresentationSupplier.class, (Object)this.xImpressDoc);
        XNameContainer oObj = oPS.getCustomPresentations();
        XSingleServiceFactory oSingleMSF = UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)oObj);
        XInterface oInstance = null;
        XInterface oSecondInstance = null;
        try {
            oInstance = (XInterface)oSingleMSF.createInstance();
            oSecondInstance = (XInterface)oSingleMSF.createInstance();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instance", e);
        }
        XNameContainer aContainer = UnoRuntime.queryInterface(XNameContainer.class, (Object)oObj);
        if (aContainer.hasByName("FirstPresentation")) {
            try {
                aContainer.removeByName("FirstPresentation");
            }
            catch (WrappedTargetException e) {
                e.printStackTrace(log);
                throw new StatusException("Exception while removing instance", e);
            }
            catch (NoSuchElementException e) {
                e.printStackTrace(log);
                throw new StatusException("Exception while removing instance", e);
            }
        }
        try {
            aContainer.insertByName("FirstPresentation", oInstance);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert Instance", e);
        }
        catch (ElementExistException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert Instance", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert Instance", e);
        }
        log.println("creating a new environment for XPresentation object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("SecondInstance", oSecondInstance);
        int THRCNT = 1;
        if ((String)Param.get("THRCNT") != null) {
            THRCNT = Integer.parseInt((String)Param.get("THRCNT"));
        }
        log.println("adding XNameContainerINDEX as mod relation to environment");
        tEnv.addObjRelation("XNameContainerINDEX", new Integer(THRCNT).toString());
        log.println("adding INSTANCEn as mod relation to environment");
        try {
            for (int n = 1; n < 2 * THRCNT + 1; ++n) {
                log.println("adding INSTANCE" + n + " as mod relation to environment");
                oInstance = (XInterface)oSingleMSF.createInstance();
                tEnv.addObjRelation("INSTANCE" + n, oInstance);
            }
        }
        catch (Exception e) {
            log.println("Could't adding INSTANCEn: " + e);
        }
        return tEnv;
    }
}

