/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XIndexContainer;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.presentation.XCustomPresentationSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SdXCustomPresentation
extends TestCase {
    XComponent xImpressDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a draw document");
            this.xImpressDoc = SOF.createImpressDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xImpressDoc");
        DesktopTools.closeDoc(this.xImpressDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        log.println("creating a test environment");
        log.println("get presentation");
        XCustomPresentationSupplier oPS = UnoRuntime.queryInterface(XCustomPresentationSupplier.class, (Object)this.xImpressDoc);
        XNameContainer oObj = oPS.getCustomPresentations();
        XSingleServiceFactory oSingleMSF = UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)oObj);
        XInterface oInstance = null;
        try {
            oInstance = (XInterface)oSingleMSF.createInstance();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instance", e);
        }
        XNameContainer aContainer = UnoRuntime.queryInterface(XNameContainer.class, (Object)oObj);
        try {
            aContainer.insertByName("FirstPresentation", oInstance);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert Presentation", e);
        }
        catch (ElementExistException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert Presentation", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert Presentation", e);
        }
        log.println("getting Drawpage");
        XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xImpressDoc);
        XDrawPages oDPn = oDPS.getDrawPages();
        XIndexAccess oDPi = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oDPn);
        XDrawPage oDrawPage = null;
        try {
            oDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oDPi.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        XIndexContainer aIContainer = UnoRuntime.queryInterface(XIndexContainer.class, (Object)oInstance);
        try {
            aIContainer.insertByIndex(0, oDrawPage);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert DrawPage", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert DrawPage", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't insert DrawPage", e);
        }
        log.println("creating a new environment for XPresentation object");
        TestEnvironment tEnv = new TestEnvironment(oInstance);
        int THRCNT = 1;
        if ((String)Param.get("THRCNT") != null) {
            THRCNT = Integer.parseInt((String)Param.get("THRCNT"));
        }
        log.println("adding XIndexContainerINDEX as mod relation to environment");
        tEnv.addObjRelation("XIndexContainerINDEX", "0");
        log.println("adding INSTANCEn as mod relation to environment");
        try {
            for (int n = 1; n < 2 * THRCNT + 1; ++n) {
                log.println("adding INSTANCE" + n + " as mod relation to environment");
                oDPn.insertNewByIndex(0);
                oDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oDPi.getByIndex(0));
                tEnv.addObjRelation("INSTANCE" + n, oDrawPage);
            }
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't adding INSTANCEn", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't adding INSTANCEn", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Could't adding INSTANCEn", e);
        }
        return tEnv;
    }
}

