/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.awt.XWindow;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.utils;

public class SdUnoSlideView
extends TestCase {
    XDesktop the_Desk;
    XComponent xImpressDoc;
    XComponent xSecondDrawDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        this.the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing impress documents");
        DesktopTools.closeDoc(this.xImpressDoc);
        DesktopTools.closeDoc(this.xSecondDrawDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        XDrawPages xDP = null;
        try {
            log.println("creating a impress document");
            this.xImpressDoc = SOF.createImpressDoc(null);
            this.shortWait();
            xDP = DrawTools.getDrawPages(this.xImpressDoc);
            xDP.insertNewByIndex(0);
            xDP.insertNewByIndex(0);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xImpressDoc);
        XController oObj = aModel.getCurrentController();
        try {
            String aSlotID = "slot:27011";
            XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)oObj);
            XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.util.URLTransformer"));
            URL[] aParseURL = new URL[]{new URL()};
            aParseURL[0].Complete = aSlotID;
            xParser.parseStrict(aParseURL);
            URL aURL = aParseURL[0];
            XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
            if (xDispatcher != null) {
                xDispatcher.dispatch(aURL, null);
            }
        }
        catch (Exception e) {
            log.println("Couldn't change to slide view");
        }
        try {
            log.println("creating a second impress document");
            this.xSecondDrawDoc = SOF.createImpressDoc(null);
            this.shortWait();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        XModel aModel2 = UnoRuntime.queryInterface(XModel.class, (Object)this.xSecondDrawDoc);
        XWindow anotherWindow = UnoRuntime.queryInterface(XWindow.class, (Object)aModel2.getCurrentController());
        oObj = aModel.getCurrentController();
        log.println("creating a new environment for slide view object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        if (anotherWindow != null) {
            tEnv.addObjRelation("XWindow.AnotherWindow", anotherWindow);
        }
        tEnv.addObjRelation("FirstModel", aModel);
        XFrame the_frame = this.the_Desk.getCurrentFrame();
        tEnv.addObjRelation("Frame", the_frame);
        tEnv.addObjRelation("SecondModel", aModel2);
        XController secondController = aModel2.getCurrentController();
        tEnv.addObjRelation("SecondController", secondController);
        tEnv.addObjRelation("XDispatchProvider.URL", "slot:27069");
        tEnv.addObjRelation("XUserInputInterception.XModel", aModel);
        try {
            Object[] selections = new Object[]{xDP.getByIndex(0), xDP.getByIndex(1), xDP.getByIndex(2)};
            tEnv.addObjRelation("Selections", selections);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
        }
        log.println("Implementation Name: " + utils.getImplName(oObj));
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }
}

