/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.awt.XWindow;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class SdUnoOutlineView
extends TestCase {
    XDesktop the_Desk;
    XComponent xImpressDoc;
    XComponent xSecondDrawDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        this.the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing impress documents");
        DesktopTools.closeDoc(this.xImpressDoc);
        DesktopTools.closeDoc(this.xSecondDrawDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a impress document");
            this.xImpressDoc = SOF.createImpressDoc(null);
            this.shortWait();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xImpressDoc);
        XDrawPages the_pages = oDPS.getDrawPages();
        XIndexAccess oDPi = UnoRuntime.queryInterface(XIndexAccess.class, (Object)the_pages);
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xImpressDoc);
        XController oObj = aModel.getCurrentController();
        try {
            String aSlotID = "slot:27010";
            XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)oObj);
            XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.util.URLTransformer"));
            URL[] aParseURL = new URL[]{new URL()};
            aParseURL[0].Complete = aSlotID;
            xParser.parseStrict(aParseURL);
            URL aURL = aParseURL[0];
            XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
            if (xDispatcher != null) {
                xDispatcher.dispatch(aURL, null);
            }
        }
        catch (Exception e) {
            log.println("Couldn't change mode");
        }
        try {
            log.println("creating a second impress document");
            this.xSecondDrawDoc = SOF.createImpressDoc(null);
            this.shortWait();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        XModel aModel2 = UnoRuntime.queryInterface(XModel.class, (Object)this.xSecondDrawDoc);
        XWindow anotherWindow = UnoRuntime.queryInterface(XWindow.class, (Object)aModel2.getCurrentController());
        oObj = aModel.getCurrentController();
        log.println("creating a new environment for impress view object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        if (anotherWindow != null) {
            tEnv.addObjRelation("XWindow.AnotherWindow", anotherWindow);
        }
        tEnv.addObjRelation("FirstModel", aModel);
        tEnv.addObjRelation("XUserInputInterception.XModel", aModel);
        XFrame the_frame = this.the_Desk.getCurrentFrame();
        tEnv.addObjRelation("Frame", the_frame);
        aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xSecondDrawDoc);
        tEnv.addObjRelation("SecondModel", aModel);
        XController secondController = aModel.getCurrentController();
        tEnv.addObjRelation("SecondController", secondController);
        tEnv.addObjRelation("XDispatchProvider.URL", "slot:27069");
        log.println("Implementation Name: " + utils.getImplName(oObj));
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }
}

