/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.awt.XWindow;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XModifiable;
import java.io.PrintWriter;
import java.util.Comparator;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class SdUnoDrawView
extends TestCase {
    static XDesktop the_Desk;
    static XComponent xDrawDoc;
    static XComponent xSecondDrawDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing draw documents");
        DesktopTools.closeDoc(xDrawDoc);
        DesktopTools.closeDoc(xSecondDrawDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating two draw documents");
            xDrawDoc = SOF.createDrawDoc(null);
            this.shortWait();
            xSecondDrawDoc = SOF.createDrawDoc(null);
            this.shortWait();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        log.println("getting Drawpage");
        XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xDrawDoc);
        XDrawPages the_pages = oDPS.getDrawPages();
        XIndexAccess oDPi = UnoRuntime.queryInterface(XIndexAccess.class, (Object)the_pages);
        XDrawPage oDrawPage = null;
        try {
            oDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oDPi.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get DrawPage", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get DrawPage", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get DrawPage", e);
        }
        log.println("inserting some Shapes");
        XShapes oShapes = UnoRuntime.queryInterface(XShapes.class, (Object)oDrawPage);
        XShape shape1 = SOF.createShape(xDrawDoc, 3000, 4500, 15000, 1000, "Ellipse");
        XShape shape2 = SOF.createShape(xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle");
        XShape shape3 = SOF.createShape(xDrawDoc, 3000, 500, 5000, 1000, "Line");
        oShapes.add(shape1);
        oShapes.add(shape2);
        oShapes.add(shape3);
        this.shortWait();
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xDrawDoc);
        XController oObj = aModel.getCurrentController();
        XModel aModel2 = UnoRuntime.queryInterface(XModel.class, (Object)xSecondDrawDoc);
        XWindow anotherWindow = UnoRuntime.queryInterface(XWindow.class, (Object)aModel2.getCurrentController());
        log.println("creating a new environment for impress view object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        if (anotherWindow != null) {
            tEnv.addObjRelation("XWindow.AnotherWindow", anotherWindow);
        }
        tEnv.addObjRelation("Selections", new Object[]{shape1, shape2, shape3});
        tEnv.addObjRelation("Pages", the_pages);
        tEnv.addObjRelation("FirstModel", aModel);
        tEnv.addObjRelation("XUserInputInterception.XModel", aModel);
        XFrame the_frame = the_Desk.getCurrentFrame();
        tEnv.addObjRelation("Frame", the_frame);
        aModel = UnoRuntime.queryInterface(XModel.class, (Object)xSecondDrawDoc);
        tEnv.addObjRelation("SecondModel", aModel);
        XController secondController = aModel.getCurrentController();
        tEnv.addObjRelation("SecondController", secondController);
        tEnv.addObjRelation("XDispatchProvider.URL", "slot:27009");
        XDrawPage new_page = the_pages.insertNewByIndex(1);
        tEnv.addObjRelation("DrawPage", new_page);
        log.println("Implementation Name: " + utils.getImplName(oObj));
        XModifiable modify = UnoRuntime.queryInterface(XModifiable.class, (Object)xDrawDoc);
        tEnv.addObjRelation("Modifiable", modify);
        tEnv.addObjRelation("XComponent.DisposeThis", xDrawDoc);
        tEnv.addObjRelation("Comparer", new Comparator(){

            public int compare(Object o1, Object o2) {
                XIndexAccess indAc1 = UnoRuntime.queryInterface(XIndexAccess.class, o1);
                XIndexAccess indAc2 = UnoRuntime.queryInterface(XIndexAccess.class, o2);
                if (indAc1 == null || indAc2 == null) {
                    return -1;
                }
                if (indAc1.getCount() == indAc2.getCount()) {
                    return 0;
                }
                return 1;
            }

            @Override
            public boolean equals(Object obj) {
                return this.compare(this, obj) == 0;
            }
        });
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }
}

